<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('productcollection_id')->unsigned()->default('0');
			$table->integer('position');
			$table->decimal('purchase_price', 18,2)->default('0');
			$table->decimal('margin', 5,2)->default('0');
			$table->decimal('selling_price', 18,2)->default('0');
			$table->decimal('stock', 10,2)->default('0');
			$table->string('unit_quantity', 255);
			$table->integer('min_quantity')->default('0');
			$table->integer('quantity_increment');
			$table->string('sku', 255);
			$table->string('gtin', 255);
			$table->string('mpn', 255);
			$table->string('ean', 255);
			$table->decimal('length_value', 10,4)->default('0');
			$table->decimal('width_value', 10,4)->default('0');
			$table->decimal('height_value', 10,4)->default('0');
			$table->decimal('weight_value', 10,4)->default('0');
			$table->decimal('volume_value', 10,4)->default('0');
			$table->string('length_unit', 255)->default('mm');
			$table->string('width_unit', 255)->default('mm');
			$table->string('height_unit', 255)->default('mm');
			$table->string('weight_unit', 255)->default('mm');
			$table->string('volume_unit', 255)->default('mm');
			$table->text('description');
			$table->timestamps();
			$table->integer('updated_by')->unsigned()->default('0');
			$table->integer('created_by')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}