<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCashierCashTable extends Migration {

	public function up()
	{
		Schema::create('cashier_cash', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->date('transaction_date');
			$table->enum('status', array('Open', 'Closed'));
			$table->decimal('cash_open', 18,2)->default('0');
			$table->decimal('cash_closed', 18,2)->default('0');
			$table->decimal('cash_actual', 18,2)->default('0');
			$table->integer('created_by')->unsigned()->default('0');
			$table->integer('updated_by')->unsigned()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('cashier_cash');
	}
}