<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersDataTable extends Migration {

	public function up()
	{
		Schema::create('orders_data', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('order_id')->unsigned()->index();
			$table->string('from');
			$table->string('to');
			$table->timestamp('date_from');
			$table->timestamp('date_to');
			$table->string('geo_from');
			$table->string('geo_to');
			$table->text('notes');
		});
	}

	public function down()
	{
		Schema::drop('orders_data');
	}
}