<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('Orders', function(Blueprint $table) {
			$table->foreign('area_id')->references('id')->on('Areas')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('Orders', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('Categories')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('orders_data', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('Orders')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('order_status', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('Orders')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Orders', function(Blueprint $table) {
			$table->dropForeign('Orders_user_id_foreign');
		});
		Schema::table('Orders', function(Blueprint $table) {
			$table->dropForeign('Orders_area_id_foreign');
		});
		Schema::table('Orders', function(Blueprint $table) {
			$table->dropForeign('Orders_category_id_foreign');
		});
		Schema::table('orders_data', function(Blueprint $table) {
			$table->dropForeign('orders_data_order_id_foreign');
		});
		Schema::table('order_status', function(Blueprint $table) {
			$table->dropForeign('order_status_order_id_foreign');
		});
	}
}