<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTripsTable extends Migration {

	public function up()
	{
		Schema::create('trips', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name');
			$table->string('last_name');
			$table->string('email');
			$table->string('phone_number');
			$table->string('pnr');
			$table->integer('from_airport_id')->unsigned();
			$table->integer('to_airport_id')->unsigned()->nullable();
			$table->datetime('trip_date');
			$table->string('test_result_url');
			$table->string('vaccination_certificate_url');
			$table->string('passport_front_page_url')->nullable();
			$table->string('test_result_password')->nullable();
			$table->string('vaccination_certificate_password')->nullable();
			$table->string('passport_front_page_password')->nullable();
			$table->json('questions')->nullable();
			$table->enum('status', array('approved', 'rejected', 'changesrequired', 'prending'));
			$table->integer('lab_id')->unsigned();
			$table->json('countries_traveled')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('trips');
	}
}