<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ArtProjectLike extends Model 
{

    protected $table = 'art_project_like';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'art_project_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function art_project()
    {
        return $this->belongsTo('ArtProject', 'art_project_id');
    }

}