<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Contract extends Model 
{

    protected $table = 'contract';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'symbol', 'address', 'abi', 'base_uri', 'mint_price', 'max_per_minute', 'max_owned_per_wallet', 'presale_mint_price', 'presale_max_per_wallet', 'presale_max_owned_per_wallet', 'reveal_uri', 'reserved_supply', 'collection_id', 'is_testnet');

    public function withdrawal_addresses()
    {
        return $this->hasMany('WithdrawalAddress', 'contract_id');
    }

    public function collection()
    {
        return $this->belongsTo('Collection', 'collection_id');
    }

}