<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Group extends Model 
{

    protected $table = 'group';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('collection_id', 'name', 'size', 'is_main');

    public function collection()
    {
        return $this->belongsTo('Collection', 'collection_id');
    }

    public function layers()
    {
        return $this->belongsToMany('Layer', 'group_layer', 'layer_id', 'group_id');
    }

}