<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ItemCategory extends Model 
{

    protected $table = 'item_category';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('item_id', 'category_id');

    public function item()
    {
        return $this->belongsTo('Item', 'item_id');
    }

    public function category()
    {
        return $this->belongsTo('Category', 'category_id');
    }

}