<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MetadataCid extends Model 
{

    protected $table = 'metadata_cid';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('cid', 'collection_id');

    public function collection()
    {
        return $this->belongsTo('Collection', 'collection_id');
    }

}