<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Thread extends Model 
{

    protected $table = 'thread';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'initiated_by', 'source', 'last_message', 'initiator_read_flag', 'user_read_flag');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function initiated_by()
    {
        return $this->belongsTo('User', 'initiated_by');
    }

}