<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class WhiteList extends Model 
{

    protected $table = 'white_list';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('collection_id', 'server_id');

    public function collection()
    {
        return $this->belongsTo('Collection', 'collection_id');
    }

}