<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class WhiteListUser extends Model 
{

    protected $table = 'white_list_user';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('white_list_id', 'address', 'validated', 'source', 'username', 'userid', 'signature');

    public function white_list()
    {
        return $this->belongsTo('WhiteList', 'white_list_id');
    }

}