<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArtProjectTable extends Migration {

	public function up()
	{
		Schema::create('art_project', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->nullable();
			$table->integer('artist_id')->nullable();
			$table->integer('software_id')->nullable();
			$table->integer('technology_id')->nullable();
			$table->string('name')->nullable();
			$table->integer('views')->nullable();
			$table->boolean('launched')->nullable()->default(0);
		});
	}

	public function down()
	{
		Schema::drop('art_project');
	}
}