<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGroupTable extends Migration {

	public function up()
	{
		Schema::create('group', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('collection_id')->nullable();
			$table->string('name')->nullable();
			$table->integer('size')->nullable();
			$table->boolean('is_main')->nullable()->default(0);
		});
	}

	public function down()
	{
		Schema::drop('group');
	}
}