<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVendorWalletsTable extends Migration {

	public function up()
	{
		Schema::create('vendor_wallets', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('vendor_id')->unsigned();
			$table->string('provider_name');
			$table->string('account_no');
			$table->enum('type', array('bank', 'wallet'));
		});
	}

	public function down()
	{
		Schema::drop('vendor_wallets');
	}
}