<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMemoriesTable extends Migration {

	public function up()
	{
		Schema::create('memories', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->enum('privacy', array('public', 'friends'));
			$table->integer('city_id')->unsigned();
			$table->enum('type', array('person', 'before_after', 'video'));
			$table->string('latitude')->nullable();
			$table->string('longitude')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('memories');
	}
}