<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersJobTable extends Migration {

	public function up()
	{
		Schema::create('users_job', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('job_id')->unsigned()->nullable();
			$table->string('another', 255)->nullable();
			$table->string('start_year', 255)->nullable();
			$table->string('status', 255)->nullable();
			$table->enum('start_year_type', array('gregorian', 'hijri'));
			$table->integer('employer_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users_job');
	}
}