<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserPhotosTable extends Migration {

	public function up()
	{
		Schema::create('user_photos', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('image_path', 255);
			$table->longText('description');
			$table->string('taken_at', 255);
			$table->enum('calendar', array('gregorian', 'hijri'));
			$table->integer('city_id')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_photos');
	}
}