<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEducationalInstitutionsTable extends Migration {

	public function up()
	{
		Schema::create('educational_institutions', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->enum('level', array('primary', 'middle', 'secondary', 'university', 'postgraduate'))->nullable();
			$table->boolean('is_official')->default(true);
			$table->enum('status', array('pending', 'approved', 'rejected'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('educational_institutions');
	}
}