<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->datetime('order_date');
			$table->float('order_tax');
			$table->float('order_total');
			$table->float('order_promotion');
			$table->enum('status', array('initiee', 'validee', 'payee', 'enattentedelivraison', 'livree', 'annulee'));
			$table->integer('id_user')->unsigned();
			$table->integer('id_coupon')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}