<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductMetaTable extends Migration {

	public function up()
	{
		Schema::create('product_meta', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->float('avg_rating');
			$table->integer('total_sales');
			$table->integer('rating_count');
			$table->datetime('date_start')->nullable();
			$table->datetime('date_end')->nullable();
			$table->string('guid', 255)->nullable();
			$table->integer('id_epice')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('product_meta');
	}
}