<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderItemsTable extends Migration {

	public function up()
	{
		Schema::create('order_items', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_order')->unsigned();
			$table->timestamps();
			$table->float('tax_rate');
			$table->float('price');
			$table->float('promotion_amount')->nullable();
			$table->float('order_item_amount');
			$table->float('tax_amount');
			$table->string('guid', 255)->nullable();
			$table->integer('id_epice');
		});
	}

	public function down()
	{
		Schema::drop('order_items');
	}
}