<?php

namespace App\Models;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;
	protected $fillable = array('order_date', 'order_tax', 'order_total', 'order_promotion', 'status', 'id_user', 'id_coupon');
	protected $visible = array('order_date', 'order_tax', 'order_total', 'order_promotion', 'status', 'id_user', 'id_coupon');

	public function user()
	{
		return $this->belongsTo('App\Models\User', 'id_user');
	}

	public function order_items()
	{
		return $this->hasMany('App\Models\Order_item', 'id_order');
	}

	public function coupon()
	{
		return $this->belongsTo('App\Models\Coupon', 'id_coupon');
	}

	public function invoices()
	{
		return $this->hasMany('App\Models\Invoice', 'id_order');
	}

}