<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BrandModel extends Model 
{

    protected $table = 'brand_models';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function brand()
    {
        return $this->belongsTo('Brand');
    }

    public function products()
    {
        return $this->hasMany('Products');
    }

    public function offers()
    {
        return $this->belongsTo('Offers');
    }

}