<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOffersTable extends Migration {

	public function up()
	{
		Schema::create('offers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('offer_id', 20);
			$table->string('offer_type', 20);
			$table->string('offer_name', 255);
			$table->string('offer_description', 255);
			$table->integer('on_number_of_items');
			$table->float('discount_amount', 5,5);
			$table->string('expiration_timing', 50);
			$table->boolean('is_active');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('offers');
	}
}