<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSellersTable extends Migration {

	public function up()
	{
		Schema::create('sellers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('users_id');
			$table->string('seller_name', 50);
			$table->string('seller_address', 255);
			$table->string('seller_phone', 20);
			$table->string('seller_alt_phone', 20);
			$table->string('seller_role', 50);
			$table->integer('seller_rating');
			$table->boolean('is_active');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('sellers');
	}
}