<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('product_code', 20);
			$table->string('product_name', 255);
			$table->string('product_title', 255);
			$table->string('product_subtitle', 255);
			$table->string('product_description', 255);
			$table->integer('product_stock');
			$table->float('cost', 10,2);
			$table->float('display_price')->default('10,2');
			$table->boolean('is_active');
			$table->integer('product_avg_rating');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}