<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('name', 'password', 'phone', 'd_o_b', 'email', 'last_donation_date', 'pin_code', 'blood_type_id', 'city_id', 'is-active');

	public function bloodType()
	{
		return $this->belongsTo('App\Models\BloodType');
	}

	public function city()
	{
		return $this->belongsTo('App\Models\City');
	}

	public function donationRequest()
	{
		return $this->hasMany('App\Models\DonationRequest');
	}

	public function posts()
	{
		return $this->morphedByMany('App\Models\Post');
	}

	public function bloodtypes()
	{
		return $this->morphedByMany('App\Models\BloodType');
	}

	public function governorates()
	{
		return $this->morphedByMany('App\Models\Governorate');
	}

	public function notetifications()
	{
		return $this->belongsToMany('App\Models\Notification');
	}

}