<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->integer('role_id')->unsigned()->nullable()->default('null');
			$table->string('email')->unique()->nullable()->default('null');
			$table->string('mobile')->unique();
			$table->string('type');
			$table->string('full_name');
			$table->string('password');
			$table->string('latitude');
			$table->string('longitude');
			$table->enum('gender', array('male', 'female'));
			$table->enum('lang', array('ar', 'en'));
			$table->enum('active', array('active', 'deactive', 'wait_admin_confirm'));
			$table->string('code')->nullable();
			$table->integer('num_try_active')->default('0');
			$table->enum('online', array('true', 'false'));
			$table->string('image');
			$table->string('first_name');
			$table->string('last_name');
			$table->date('date_of_birth')->nullable();
			$table->enum('available', array('true', 'false'));
			$table->enum('notification_toggle', array('true', 'false'));
			$table->double('wallet')->default('0');
			$table->text('address')->nullable();
			$table->uuid('uuid');
			$table->integer('points');
			$table->text('tax_number')->nullable();
			$table->text('description')->nullable();
			$table->rememberToken();
			$table->string('reset_code')->nullable();
			$table->double('app_commission')->default('0.0');
			$table->integer('rates')->default('0');
			$table->double('total_commission')->default('0');
			$table->float('wallet_balance')->default('0');
			$table->boolean('reservation_availability')->default(0);
			$table->text('user_note')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}