<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('permissions', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('sub_permissions', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('currency_data', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('restaurant_setting', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('restaurant_setting_data', function(Blueprint $table) {
			$table->foreign('restaurant_setting_id')->references('id')->on('restaurant_setting')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('restaurant_sections', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('restaurant_section_data', function(Blueprint $table) {
			$table->foreign('restaurant_section_id')->references('id')->on('restaurant_sections')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('coupon_data', function(Blueprint $table) {
			$table->foreign('coupon_id')->references('id')->on('coupons')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('zone_data', function(Blueprint $table) {
			$table->foreign('zone_id')->references('id')->on('zones')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('permissions', function(Blueprint $table) {
			$table->dropForeign('permissions_role_id_foreign');
		});
		Schema::table('sub_permissions', function(Blueprint $table) {
			$table->dropForeign('sub_permissions_permission_id_foreign');
		});
		Schema::table('currency_data', function(Blueprint $table) {
			$table->dropForeign('currency_data_currency_id_foreign');
		});
		Schema::table('restaurant_setting', function(Blueprint $table) {
			$table->dropForeign('restaurant_setting_restaurant_id_foreign');
		});
		Schema::table('restaurant_setting_data', function(Blueprint $table) {
			$table->dropForeign('restaurant_setting_data_restaurant_setting_id_foreign');
		});
		Schema::table('restaurant_sections', function(Blueprint $table) {
			$table->dropForeign('restaurant_sections_restaurant_id_foreign');
		});
		Schema::table('restaurant_section_data', function(Blueprint $table) {
			$table->dropForeign('restaurant_section_data_restaurant_section_id_foreign');
		});
		Schema::table('coupon_data', function(Blueprint $table) {
			$table->dropForeign('coupon_data_coupon_id_foreign');
		});
		Schema::table('zone_data', function(Blueprint $table) {
			$table->dropForeign('zone_data_zone_id_foreign');
		});
	}
}