<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Campaign extends Eloquent {

	protected $table = 'campaigns';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'start_date', 'end_date');

	public function accounts()
	{
		return $this->belongsToMany('App\Account');
	}

}