<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $guarded = array('password');
	protected $fillable = array('phone', 'metadata');
	protected $visible = array('phone');

	public function groups()
	{
		return $this->belongsToMany('Group');
	}

	public function institution()
	{
		return $this->hasManyThrough('App\User', 'App\Group');
	}

}