<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlansTable extends Migration {

	public function up()
	{
		Schema::create('plans', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->text('description');
			$table->string('namespace')->unique();
			$table->double('price');
			$table->integer('created_by')->unsigned()->nullable()->index();
			$table->timestamps();
			$table->integer('updated_by')->unsigned()->nullable()->index();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('plans');
	}
}