<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('product', function(Blueprint $table) {
			$table->foreign('category_id')->references('category_id')->on('category')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->foreign('brand_id')->references('brand_id')->on('brand')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user', function(Blueprint $table) {
			$table->foreign('role_id')->references('role_id')->on('role')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('shipping', function(Blueprint $table) {
			$table->foreign('order_id')->references('order_id')->on('order')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('shipping_id')->references('shipping_id')->on('shipping')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('payment_id')->references('payment_id')->on('payment')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->foreign('order_id')->references('order_id')->on('order')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->foreign('product_id')->references('product_id')->on('product')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('address', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('image', function(Blueprint $table) {
			$table->foreign('product_id')->references('product_id')->on('product')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->foreign('product_id')->references('product_id')->on('product')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('product', function(Blueprint $table) {
			$table->dropForeign('product_category_id_foreign');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->dropForeign('product_brand_id_foreign');
		});
		Schema::table('user', function(Blueprint $table) {
			$table->dropForeign('user_role_id_foreign');
		});
		Schema::table('shipping', function(Blueprint $table) {
			$table->dropForeign('shipping_order_id_foreign');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_user_id_foreign');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_shipping_id_foreign');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_payment_id_foreign');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->dropForeign('order_details_order_id_foreign');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->dropForeign('order_details_product_id_foreign');
		});
		Schema::table('address', function(Blueprint $table) {
			$table->dropForeign('address_user_id_foreign');
		});
		Schema::table('image', function(Blueprint $table) {
			$table->dropForeign('image_product_id_foreign');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->dropForeign('cart_user_id_foreign');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->dropForeign('cart_product_id_foreign');
		});
	}
}