<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('usuario', function(Blueprint $table) {
			$table->foreign('tipo_usuario_id')->references('id')->on('tipo_usuario')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('usuario', function(Blueprint $table) {
			$table->foreign('planta_id')->references('id')->on('planta')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trabajador', function(Blueprint $table) {
			$table->foreign('planta_id')->references('id')->on('planta')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trabajador', function(Blueprint $table) {
			$table->foreign('area_id')->references('id')->on('area')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('articulo', function(Blueprint $table) {
			$table->foreign('trabajador_id')->references('id')->on('trabajador')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('articulo', function(Blueprint $table) {
			$table->foreign('ropa_id')->references('id')->on('ropa')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('articulo', function(Blueprint $table) {
			$table->foreign('estado_id')->references('id')->on('estado_articulo')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lote', function(Blueprint $table) {
			$table->foreign('estado_id')->references('id')->on('estado_lote')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('area_ropa', function(Blueprint $table) {
			$table->foreign('area_id')->references('id')->on('area')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('area_ropa', function(Blueprint $table) {
			$table->foreign('ropa_id')->references('id')->on('ropa')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('articulo_lote', function(Blueprint $table) {
			$table->foreign('articulo_id')->references('id')->on('articulo')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('articulo_lote', function(Blueprint $table) {
			$table->foreign('lote_id')->references('id')->on('lote')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('usuario', function(Blueprint $table) {
			$table->dropForeign('usuario_tipo_usuario_id_foreign');
		});
		Schema::table('usuario', function(Blueprint $table) {
			$table->dropForeign('usuario_planta_id_foreign');
		});
		Schema::table('trabajador', function(Blueprint $table) {
			$table->dropForeign('trabajador_planta_id_foreign');
		});
		Schema::table('trabajador', function(Blueprint $table) {
			$table->dropForeign('trabajador_area_id_foreign');
		});
		Schema::table('articulo', function(Blueprint $table) {
			$table->dropForeign('articulo_trabajador_id_foreign');
		});
		Schema::table('articulo', function(Blueprint $table) {
			$table->dropForeign('articulo_ropa_id_foreign');
		});
		Schema::table('articulo', function(Blueprint $table) {
			$table->dropForeign('articulo_estado_id_foreign');
		});
		Schema::table('lote', function(Blueprint $table) {
			$table->dropForeign('lote_estado_id_foreign');
		});
		Schema::table('area_ropa', function(Blueprint $table) {
			$table->dropForeign('area_ropa_area_id_foreign');
		});
		Schema::table('area_ropa', function(Blueprint $table) {
			$table->dropForeign('area_ropa_ropa_id_foreign');
		});
		Schema::table('articulo_lote', function(Blueprint $table) {
			$table->dropForeign('articulo_lote_articulo_id_foreign');
		});
		Schema::table('articulo_lote', function(Blueprint $table) {
			$table->dropForeign('articulo_lote_lote_id_foreign');
		});
	}
}