<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('student', function(Blueprint $table) {
			$table->foreign('profile')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('student', function(Blueprint $table) {
			$table->foreign('mother_id')->references('id')->on('parent')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('student', function(Blueprint $table) {
			$table->foreign('father_id')->references('id')->on('parent')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('teacher', function(Blueprint $table) {
			$table->foreign('profile')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('teacher', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('department')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('club', function(Blueprint $table) {
			$table->foreign('responsable_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('book_copy', function(Blueprint $table) {
			$table->foreign('book_id')->references('id')->on('book')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('borrowing', function(Blueprint $table) {
			$table->foreign('book_copy_id')->references('id')->on('book_copy')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('borrowing', function(Blueprint $table) {
			$table->foreign('borrowedBy')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('borrowing', function(Blueprint $table) {
			$table->foreign('biblio_id')->references('id')->on('biblio')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('event', function(Blueprint $table) {
			$table->foreign('calendar_id')->references('id')->on('calendar')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('staff', function(Blueprint $table) {
			$table->foreign('profile')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vehicle', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vehicle', function(Blueprint $table) {
			$table->foreign('authorisation_id')->references('id')->on('authorisation')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('absence', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('grade', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('student')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('grade', function(Blueprint $table) {
			$table->foreign('assessment_id')->references('id')->on('assessment')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('delayed', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('scientific_board', function(Blueprint $table) {
			$table->foreign('teacher_id')->references('id')->on('student')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lesson', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('course')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lesson', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('event')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('assessment', function(Blueprint $table) {
			$table->foreign('teacher_id')->references('id')->on('teacher')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('assessment', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('course')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('assessment', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('event')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('quiz', function(Blueprint $table) {
			$table->foreign('lesson_id')->references('id')->on('lesson')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('forum_post', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('course')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_progress', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('student')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('quiz_qr', function(Blueprint $table) {
			$table->foreign('quiz_id')->references('id')->on('quiz')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('forum_msg', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('forum_post')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('forum_msg', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('student', function(Blueprint $table) {
			$table->dropForeign('student_profile_foreign');
		});
		Schema::table('student', function(Blueprint $table) {
			$table->dropForeign('student_mother_id_foreign');
		});
		Schema::table('student', function(Blueprint $table) {
			$table->dropForeign('student_father_id_foreign');
		});
		Schema::table('teacher', function(Blueprint $table) {
			$table->dropForeign('teacher_profile_foreign');
		});
		Schema::table('teacher', function(Blueprint $table) {
			$table->dropForeign('teacher_department_id_foreign');
		});
		Schema::table('club', function(Blueprint $table) {
			$table->dropForeign('club_responsable_id_foreign');
		});
		Schema::table('book_copy', function(Blueprint $table) {
			$table->dropForeign('book_copy_book_id_foreign');
		});
		Schema::table('borrowing', function(Blueprint $table) {
			$table->dropForeign('borrowing_book_copy_id_foreign');
		});
		Schema::table('borrowing', function(Blueprint $table) {
			$table->dropForeign('borrowing_borrowedBy_foreign');
		});
		Schema::table('borrowing', function(Blueprint $table) {
			$table->dropForeign('borrowing_biblio_id_foreign');
		});
		Schema::table('event', function(Blueprint $table) {
			$table->dropForeign('event_calendar_id_foreign');
		});
		Schema::table('staff', function(Blueprint $table) {
			$table->dropForeign('staff_profile_foreign');
		});
		Schema::table('vehicle', function(Blueprint $table) {
			$table->dropForeign('vehicle_user_id_foreign');
		});
		Schema::table('vehicle', function(Blueprint $table) {
			$table->dropForeign('vehicle_authorisation_id_foreign');
		});
		Schema::table('absence', function(Blueprint $table) {
			$table->dropForeign('absence_user_id_foreign');
		});
		Schema::table('grade', function(Blueprint $table) {
			$table->dropForeign('grade_student_id_foreign');
		});
		Schema::table('grade', function(Blueprint $table) {
			$table->dropForeign('grade_assessment_id_foreign');
		});
		Schema::table('delayed', function(Blueprint $table) {
			$table->dropForeign('delayed_user_id_foreign');
		});
		Schema::table('scientific_board', function(Blueprint $table) {
			$table->dropForeign('scientific_board_teacher_id_foreign');
		});
		Schema::table('lesson', function(Blueprint $table) {
			$table->dropForeign('lesson_course_id_foreign');
		});
		Schema::table('lesson', function(Blueprint $table) {
			$table->dropForeign('lesson_event_id_foreign');
		});
		Schema::table('assessment', function(Blueprint $table) {
			$table->dropForeign('assessment_teacher_id_foreign');
		});
		Schema::table('assessment', function(Blueprint $table) {
			$table->dropForeign('assessment_course_id_foreign');
		});
		Schema::table('assessment', function(Blueprint $table) {
			$table->dropForeign('assessment_event_id_foreign');
		});
		Schema::table('quiz', function(Blueprint $table) {
			$table->dropForeign('quiz_lesson_id_foreign');
		});
		Schema::table('forum_post', function(Blueprint $table) {
			$table->dropForeign('forum_post_course_id_foreign');
		});
		Schema::table('user_progress', function(Blueprint $table) {
			$table->dropForeign('user_progress_student_id_foreign');
		});
		Schema::table('quiz_qr', function(Blueprint $table) {
			$table->dropForeign('quiz_qr_quiz_id_foreign');
		});
		Schema::table('forum_msg', function(Blueprint $table) {
			$table->dropForeign('forum_msg_post_id_foreign');
		});
		Schema::table('forum_msg', function(Blueprint $table) {
			$table->dropForeign('forum_msg_user_id_foreign');
		});
	}
}