<?php

namespace App\Modules\Ais\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Facility extends Eloquent {

	protected $table = 'ais_facility';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function positions()
	{
		return $this->hasMany('App\Modules\Ais\Models\Facility\Position');
	}

	public function airports()
	{
		return $this->hasManyThrough('App\Modules\Ais\Models\Airport', 'App\Modules\Ais\Models\AirportFacility')withPivot("top_down_order")->withTimestamps();
	}

}