<?php

namespace App\Modules\Ais\Models\Facility;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Position extends Eloquent {

	protected $table = 'ais_facility_position';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('callsign', 'frequency', 'logon_order');

	public function facility()
	{
		return $this->belongsTo('App\Modules\Ais\Models\Facility');
	}

}