<?php

namespace App\Modules\Ais\Models\Fir;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Sector extends Eloquent {

	protected $table = 'ais_fir_sector';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('fir_id', 'covered_by');

	public function airports()
	{
		return $this->hasMany('App\Modules\Ais\Models\Airport');
	}

	public function coveredBy()
	{
		return $this->belongsTo('App\Modules\Ais\Models\Fir');
	}

}