<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function units()
    {
        return $this->hasMany('App\ProductUnit', 'product_id');
    }

    public function categories()
    {
        return $this->belongsToMany('App\ProductCategory', 'products_products_categories', 'product_id', 'category_id');
    }

    public function warehouse_location()
    {
        return $this->belongsTo('App\ProductWarehouseLocation', 'warehouse_location_id');
    }

    public function adjustments()
    {
        return $this->hasMany('App\Adjustment', 'product_id');
    }

    public function purchases()
    {
        return $this->hasManyThrough('App\PurchaseLine', 'Purchases');
    }

    public function orders()
    {
        return $this->hasManyThrough('App\OrderLine', 'Orders');
    }

    public function images()
    {
        return $this->hasMany('App\ProductImage', 'product_id');
    }

}