<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PurchaseLine extends Model 
{

    protected $table = 'purchase_lines';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function purchase()
    {
        return $this->belongsTo('App\Purchase', 'purchase_id');
    }

    public function product()
    {
        return $this->belongsTo('App\Product', 'product_id');
    }

    public function unit()
    {
        return $this->belongsTo('App\ProductUnit', 'quantity_unit_id');
    }

}