<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Vendor extends Model 
{

    protected $table = 'vendors';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function purchases()
    {
        return $this->hasMany('App\Purchase', 'vendor_id');
    }

    public function product_units()
    {
        return $this->belongsToMany('App\ProductUnit', 'vendor_product', 'vendor_id', 'product_unit_id')->withPivot('name','model','cost','created_at','updated_at');
    }

}