<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('quantity_unit_id')->references('id')->on('product_units')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('warehouse_location_id')->references('id')->on('product_warehouse_locations')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('product_units', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('product_units', function(Blueprint $table) {
			$table->foreign('unit_type_id')->references('id')->on('product_unit_types')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('product_units', function(Blueprint $table) {
			$table->foreign('contains_unit_id')->references('id')->on('product_units')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('product_categories', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('product_categories')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('products_products_categories', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('products_products_categories', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('product_categories')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('order_payments', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('order_lines', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('order_lines', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('order_lines', function(Blueprint $table) {
			$table->foreign('quantity_unit_id')->references('id')->on('product_units')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('adjustments', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('adjustments', function(Blueprint $table) {
			$table->foreign('quantity_unit_id')->references('id')->on('product_units')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('purchases', function(Blueprint $table) {
			$table->foreign('vendor_id')->references('id')->on('vendors')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('purchase_lines', function(Blueprint $table) {
			$table->foreign('purchase_id')->references('id')->on('purchases')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('purchase_lines', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('purchase_lines', function(Blueprint $table) {
			$table->foreign('quantity_unit_id')->references('id')->on('product_units')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('vendor_product', function(Blueprint $table) {
			$table->foreign('product_unit_id')->references('id')->on('product_units')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('vendor_product', function(Blueprint $table) {
			$table->foreign('vendor_id')->references('id')->on('vendors')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('product_unit_barcodes', function(Blueprint $table) {
			$table->foreign('product_unit_id')->references('id')->on('product_units')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('product_images', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_quantity_unit_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_warehouse_location_id_foreign');
		});
		Schema::table('product_units', function(Blueprint $table) {
			$table->dropForeign('product_units_product_id_foreign');
		});
		Schema::table('product_units', function(Blueprint $table) {
			$table->dropForeign('product_units_unit_type_id_foreign');
		});
		Schema::table('product_units', function(Blueprint $table) {
			$table->dropForeign('product_units_contains_unit_id_foreign');
		});
		Schema::table('product_categories', function(Blueprint $table) {
			$table->dropForeign('product_categories_parent_id_foreign');
		});
		Schema::table('products_products_categories', function(Blueprint $table) {
			$table->dropForeign('products_products_categories_product_id_foreign');
		});
		Schema::table('products_products_categories', function(Blueprint $table) {
			$table->dropForeign('products_products_categories_category_id_foreign');
		});
		Schema::table('order_payments', function(Blueprint $table) {
			$table->dropForeign('order_payments_order_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_customer_id_foreign');
		});
		Schema::table('order_lines', function(Blueprint $table) {
			$table->dropForeign('order_lines_order_id_foreign');
		});
		Schema::table('order_lines', function(Blueprint $table) {
			$table->dropForeign('order_lines_product_id_foreign');
		});
		Schema::table('order_lines', function(Blueprint $table) {
			$table->dropForeign('order_lines_quantity_unit_id_foreign');
		});
		Schema::table('adjustments', function(Blueprint $table) {
			$table->dropForeign('adjustments_product_id_foreign');
		});
		Schema::table('adjustments', function(Blueprint $table) {
			$table->dropForeign('adjustments_quantity_unit_id_foreign');
		});
		Schema::table('purchases', function(Blueprint $table) {
			$table->dropForeign('purchases_vendor_id_foreign');
		});
		Schema::table('purchase_lines', function(Blueprint $table) {
			$table->dropForeign('purchase_lines_purchase_id_foreign');
		});
		Schema::table('purchase_lines', function(Blueprint $table) {
			$table->dropForeign('purchase_lines_product_id_foreign');
		});
		Schema::table('purchase_lines', function(Blueprint $table) {
			$table->dropForeign('purchase_lines_quantity_unit_id_foreign');
		});
		Schema::table('vendor_product', function(Blueprint $table) {
			$table->dropForeign('vendor_product_product_unit_id_foreign');
		});
		Schema::table('vendor_product', function(Blueprint $table) {
			$table->dropForeign('vendor_product_vendor_id_foreign');
		});
		Schema::table('product_unit_barcodes', function(Blueprint $table) {
			$table->dropForeign('product_unit_barcodes_product_unit_id_foreign');
		});
		Schema::table('product_images', function(Blueprint $table) {
			$table->dropForeign('product_images_product_id_foreign');
		});
	}
}