<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderLinesTable extends Migration {

	public function up()
	{
		Schema::create('order_lines', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id')->unsigned();
			$table->integer('product_id')->unsigned();
			$table->string('name');
			$table->integer('quantity');
			$table->integer('quantity_unit_id')->unsigned();
			$table->decimal('price', 10,2);
			$table->decimal('discount', 10,2);
			$table->decimal('cost', 16,8);
			$table->enum('custcat', array('foo', 'bar'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('order_lines');
	}
}