<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->integer('quantity')->default('0');
			$table->integer('quantity_unit_id')->unsigned()->nullable();
			$table->decimal('cost', 16,8)->default('0');
			$table->integer('warehouse_location_id')->unsigned()->nullable();
			$table->enum('custcat', array('Non-Food', 'Tobacco', 'Candy', 'Grocery'));
			$table->boolean('taxable')->default(1);
			$table->decimal('srp', 10,2);
			$table->string('pre_priced')->nullable();
			$table->boolean('active');
			$table->string('model')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}