<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PurchaseLine extends Eloquent {

	protected $table = 'purchase_lines';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function purchase()
	{
		return $this->belongsTo('App\Purchase', 'purchase_id');
	}

	public function product()
	{
		return $this->belongsTo('App\Product', 'product_id');
	}

	public function unit()
	{
		return $this->belongsTo('App\ProductUnit', 'quantity_unit_id');
	}

}