<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 191);
			$table->text('meta_details')->nullable();
			$table->text('description');
			$table->float('price');
			$table->float('discount')->nullable();
			$table->string('image', 191);
			$table->integer('quantity')->default('9');
			$table->timestamp('start_at')->nullable();
			$table->bigInteger('brand_id')->unsigned();
			$table->timestamp('published_at')->nullable();
			$table->timestamp('end_at')->nullable();
			$table->bigInteger('badge_id')->unsigned();
			$table->bigInteger('coupon_id')->unsigned();
			$table->bigInteger('country_id')->unsigned();
			$table->boolean('soon')->default(0);
			$table->boolean('out_of_stock')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}