<?php

namespace Models;

class Cart extends Eloquent {

	protected $table = 'carts';
	public $timestamps = true;
	protected $fillable = array('user_id', 'token', 'product_id', 'price', 'discount', 'quantity', 'country_id');

	public function user()
	{
		return $this->belongsTo('Models\User');
	}

	public function product()
	{
		return $this->belongsTo('Models\Product');
	}

	public function country()
	{
		return $this->belongsTo('Models\Country');
	}

}