<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CountryRole extends Eloquent {

	protected $table = 'country_roles';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('country_id');

	public function country()
	{
		return $this->belongsTo('Models\Country');
	}

	public function countryPermissions()
	{
		return $this->hasMany('Models\CountryPermission');
	}

}